/* ...............................................................

	WindowColors
	Copyright 1997-8 Steve Klingsporn <moofie@pobox.com>
	Based on WindowShade by Marco Nelissen <marcone@xs4all.nl>
	
		File:	WindowColorsApplication.h
	
	Contains:	WindowColorsApplication class definition and
				general application global includes.
	
	   Notes:	None.
	   
   ............................................................... */

#ifndef _WINDOW_COLORS_APPLICATION_H
#define _WINDOW_COLORS_APPLICATION_H

#ifndef _WINDOW_COLORS_H
#include "WindowColors.h"
#endif

#ifndef _WINDOW_COLORS_WINDOW_H
#include "WindowColorsWindow.h"
#endif


/* ...............................................................
	Startup Action Constants
	
	NORMAL_STARTUP_ACTION			Regular startup action
	RESET_TO_DEFAULTS_ACTION		Resets colors to defaults
	UPDATE_WINDOW_COLORS_ACTION		Update user settings quietly
	
	Seems kinda broken and contorted.
   ............................................................... */

enum
{
	NORMAL_STARTUP_ACTION,
	RESET_TO_DEFAULTS_ACTION,
	UPDATE_WINDOW_COLORS_ACTION,
	BOOTSCRIPT_ACTION,
	USER_BOOTSCRIPT_ACTION
};


/* ...............................................................
	Messages
	These are the messages the application uses.
   ............................................................... */

enum
{
	SET_WINDOW_COLORS 			= 'blam',
	REVERT_WINDOW_COLORS 		= 'revt',
	REVERT_TO_BE_DEFAULTS 		= 'deft',
	HIDE_ABOUT_PANEL			= 'habt',
	INVOKE_BUTTON				= 'ibut',
	COMPOSE_FEEDBACK_MESSAGE	= 'flam'
};


/* ...............................................................
	Frequently used rgb_color constants
   ............................................................... */

const rgb_color BLACK_COLOR			=	{   0,   0,   0, 255 };
const rgb_color	RGB_COLOR_152		=	{ 152, 152, 152, 255 };
const rgb_color RGB_COLOR_160		=	{ 160, 160, 160, 255 };
const rgb_color RGB_COLOR_184		=	{ 184, 184, 184, 255 };
const rgb_color RGB_COLOR_192		=	{ 192, 192, 192, 255 };
const rgb_color RGB_COLOR_216		=	{ 216, 216, 216, 255 };
const rgb_color RGB_COLOR_235		=	{ 235, 235, 235, 255 };
const rgb_color WHITE_COLOR			=	{ 255, 255, 255, 255 };


/* ...............................................................
	WindowColorsApplication class		
   ............................................................... */

class WindowColorsWindow;
class WindowColorsApplication : public BApplication
{
	public:
						WindowColorsApplication();
						
				void	ArgvReceived(int32 argc, char **argv);
				void	ReadyToRun();
				void	Quit();

			BMessage	*Settings();
				void	SavePreferredSet(rgb_color *first);
				void	LoadSettings();
				void	SaveSettings();
				
	private:
			
  WindowColorsWindow	*_window;
			BMessage	*_settings;
			int8		_startupAction;
};

/* Global application pointer */
extern WindowColorsApplication *window_colors_app;

#endif